// Generated by CoffeeScript 2.4.1
  //Copyright (c) 2013-2019 Hypothes.is Project and contributors

  //Redistribution and use in source and binary forms, with or without
  //modification, are permitted provided that the following conditions are met:

  //1. Redistributions of source code must retain the above copyright notice, this
  //   list of conditions and the following disclaimer.
  //2. Redistributions in binary form must reproduce the above copyright notice,
  //   this list of conditions and the following disclaimer in the documentation
  //   and/or other materials provided with the distribution.

  //THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  //ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  //DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  //ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  //(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  //LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  //ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  //(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  //SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  // This is a modified copy of https://github.com/hypothesis/client/blob/master/src/annotator/anchoring/types.coffee
  import { Range, SerializedRange } from './range'

  export class RangeAnchor {
    constructor(root, range) {
      if (root == null) {
        missingParameter('root');
      }
      if (range == null) {
        missingParameter('range');
      }
      this.root = root;

      this.range = Range.sniff(range).normalize(this.root);
    }

    static fromRange(root, range) {
      return new RangeAnchor(root, range);
    }

    // Create and anchor using the saved Range selector.
    static fromSelector(root, selector) {
      var data, range;
      data = {
        start: selector.startContainer,
        startOffset: selector.startOffset,
        end: selector.endContainer,
        endOffset: selector.endOffset
      };
      range = new SerializedRange(data);
      return new RangeAnchor(root, range);
    }

    toRange() {
      return this.range.toRange();
    }

    toSelector(options = {}) {
      var range;
      range = this.range.serialize(this.root, options.ignoreSelector);
      return new RangeSelector(range.start, range.end, range.startOffset, range.endOffset);
    }

  };

  export class RangeSelector {
    constructor(startContainer, endContainer, startOffset, endOffset) {
      this.type = "RangeSelector";
      this.startContainer = startContainer;
      this.endContainer = endContainer;
      this.startOffset = startOffset;
      this.endOffset = endOffset;
    }
  }
