// Generated by CoffeeScript 2.4.1
  //Copyright (c) 2013-2019 Hypothes.is Project and contributors

  //Redistribution and use in source and binary forms, with or without
  //modification, are permitted provided that the following conditions are met:

  //1. Redistributions of source code must retain the above copyright notice, this
  //   list of conditions and the following disclaimer.
  //2. Redistributions in binary form must reproduce the above copyright notice,
  //   this list of conditions and the following disclaimer in the documentation
  //   and/or other materials provided with the distribution.

  //THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  //ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  //DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
  //ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  //(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  //LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  //ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  //(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  //SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  // This is a modified copy of https://github.com/hypothesis/client/blob/master/src/annotator/anchoring/html.coffee

  import { RangeAnchor } from './Anchors'
  var querySelector;

  querySelector = function(type, root, selector, options) {
    var doQuery;
    doQuery = function(resolve, reject) {
      var anchor, error, range;
      try {
        anchor = type.fromSelector(root, selector, options);
        range = anchor.toRange(options);
        return resolve(range);
      } catch (error1) {
        error = error1;
        return reject(error);
      }
    };
    return new Promise(doQuery);
  };

  export function anchor(root, selector, options = {}) {
    var promise, range;
    range = selector;
    promise = Promise.reject("unable to anchor");
    if (range != null) {
      promise = promise.catch(function() {
        return querySelector(RangeAnchor, root, range, options);
      });
    }
    return promise;
  };

  export function describe(root, range, options = {}) {
    var anchor, selector, selectors, type, types;
    types = [RangeAnchor];
    selectors = (() => {
      var i, len, results;
      for (i = 0, len = types.length; i < len; i++) {
        type = types[i];
        try {
          anchor = type.fromRange(root, range, options);
          results = selector = anchor.toSelector(options);
        } catch (error1) {
          continue;
        }
      }
      return results;
    })();
    return selectors;
  };

