'use-strict';

let fs = require('fs')
let $ = require('jquery')

$(function () {
  const extensionOrigin = chrome.runtime.id;
  let angularAnnotator = fs.readFileSync(__dirname + "../../../../dist/annotator/index.html", 'utf8');
  console.log(extensionOrigin);
  const baseString = 'chrome-extension://'+extensionOrigin+'/';

  const shadowRoot = attachShadow(document.body);

  if (shadowRoot) {
    shadowRoot.innerHTML = angularAnnotator;
  }

  function attachShadow(element) {
    if (element.attachShadow) {
      // Shadow DOM v1 (Chrome v53, Safari 10)
      return element.attachShadow({ mode: 'open' });
    } else if (element.createShadowRoot) {
      // Shadow DOM v0 (Chrome ~35-52)
      return element.createShadowRoot();
    } else {
      return null;
    }
  }
});

 