import { TextRange } from "./pdf-text-range";

export class TextPositionAnchor {

    constructor(root, start, end) {
      this.root = root;
      this.start = start;
      this.end = end;
    }
  
    static fromRange(root, range) {
      const textRange = TextRange.fromRange(range).relativeTo(root);
      return new TextPositionAnchor(
        root,
        textRange.start.offset,
        textRange.end.offset
      );
    }
    static fromSelector(root, selector) {
      return new TextPositionAnchor(root, selector.start, selector.end);
    }
  
    toSelector() {
      return new TextPositionSelector(this.start, this,end);
    }
  
    toRange() {
      return TextRange.fromOffsets(this.root, this.start, this.end).toRange();
    }
  }

  export class TextPositionSelector {
      constructor(start, end) {
          this.type = "TextPostitionSelector";
          this.start = start;
          this.end = end;
      }
  }
