// Generated by CoffeeScript 2.4.1
//Copyright (c) 2013-2019 Hypothes.is Project and contributors

//Redistribution and use in source and binary forms, with or without
//modification, are permitted provided that the following conditions are met:

//1. Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//2. Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.

//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
//ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
//ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
//LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
//(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//This script is a modified copy of https://github.com/hypothesis/client/blob/master/src/annotator/anchoring/util.coffee
import * as $ from 'jquery'
import { simpleXPathJQuery, simpleXPathPure } from './xpath';

export var Util = {};

// Public: Flatten a nested array structure

// Returns an array
Util.flatten = function (array) {
  var flatten;
  flatten = function (ary) {
    var el, flat, i, len;
    flat = [];
    for (i = 0, len = ary.length; i < len; i++) {
      el = ary[i];
      flat = flat.concat(el && $.isArray(el) ? flatten(el) : el);
    }
    return flat;
  };
  return flatten(array);
};

// Public: decides whether node A is an ancestor of node B.

// This function purposefully ignores the native browser function for this,
// because it acts weird in PhantomJS.
// Issue: https://github.com/ariya/phantomjs/issues/11479
Util.contains = function (parent, child) {
  var node;
  node = child;
  while (node != null) {
    if (node === parent) {
      return true;
    }
    node = node.parentNode;
  }
  return false;
};

// Public: Finds all text nodes within the elements in the current collection.

// Returns a new jQuery collection of text nodes.
Util.getTextNodes = function (jq) {
  var getTextNodes;
  getTextNodes = function (node) {
    var nodes;
    if (node && node.nodeType !== Node.TEXT_NODE) {
      nodes = [];
      // If not a comment then traverse children collecting text nodes.
      // We traverse the child nodes manually rather than using the .childNodes
      // property because IE9 does not update the .childNodes property after
      // .splitText() is called on a child text node.
      if (node.nodeType !== Node.COMMENT_NODE) {
        // Start at the last child and walk backwards through siblings.
        node = node.lastChild;
        while (node) {
          nodes.push(getTextNodes(node));
          node = node.previousSibling;
        }
      }
      // Finally reverse the array so that nodes are in the correct order.
      return nodes.reverse();
    } else {
      return node;
    }
  };
  return jq.map(function () {
    return Util.flatten(getTextNodes(this));
  });
};

//Collect all text content of the given text nodes and join them to one text node.
Util.joinTextNodes = function (jqNodeArray) {
  let textContent = "";
  for (let textNode of jqNodeArray) {
    textContent += textNode.textContent;
  }
  return document.createTextNode(textContent);
}

Util.getPreviousTextElement = function (node) {
  if (node !== null) {
    let result;
    if (node.previousSibling !== null) {
      result = Util.getLastTextNodeUpTo(node.previousSibling);
      if (result !== null) {
        return result;
      } else {
        return Util.getPreviousTextElement(node.parentElement);
      }
    } else {
      return Util.getPreviousTextElement(node.parentElement);
    }

  } else {
    return null;
  }

}

Util.getNextTextElement = function (node) {
  if (node !== null) {
    let result;
    if (node.nextSibling !== null) {
      result = Util.getFirstTextNodeNotBefore(node.nextSibling);
      if (result !== null) {
        return result;
      } else {
        return Util.getNextTextElement(node.parentElement);
      }
    } else {
      return Util.getNextTextElement(node.parentElement);
    }
  } else {
    return null;
  }

}

// Public: determine the last text node inside or before the given node
Util.getLastTextNodeUpTo = function (n) {
  var result;
  switch (n.nodeType) {
    case Node.TEXT_NODE:
      return n; // We have found our text node.
    case Node.ELEMENT_NODE:
      // This is an element, we need to dig in
      if (n.lastChild != null) {
        result = Util.getLastTextNodeUpTo(n.lastChild);
        if (result != null) {
          return result;
        } // Does it have children at all?
      }
      break;
  }
  // Not a text node, and not an element node.
  // Could not find a text node in current node, go backwards
  n = n.previousSibling;
  if (n != null) {
    return Util.getLastTextNodeUpTo(n);
  } else {
    return null;
  }
};

// Public: determine the first text node in or after the given jQuery node.
Util.getFirstTextNodeNotBefore = function (n) {
  var result;
  switch (n.nodeType) {
    case Node.TEXT_NODE:
      return n; // We have found our text node.
    case Node.ELEMENT_NODE:
      // This is an element, we need to dig in
      if (n.firstChild != null) {
        result = Util.getFirstTextNodeNotBefore(n.firstChild);
        if (result != null) {
          return result;
        } // Does it have children at all?
      }
      break;
  }
  // Not a text or an element node.
  // Could not find a text node in current node, go forward
  n = n.nextSibling;
  if (n != null) {
    return Util.getFirstTextNodeNotBefore(n);
  } else {
    return null;
  }
};

// Public: read out the text value of a range using the selection API

// This method selects the specified range, and asks for the string
// value of the selection. What this returns is very close to what the user
// actually sees.
Util.readRangeViaSelection = function (range) {
  var sel;
  sel = Util.getGlobal().getSelection(); // Get the browser selection object
  sel.removeAllRanges(); // clear the selection
  sel.addRange(range.toRange()); // Select the range
  return sel.toString(); // Read out the selection
};

Util.xpathFromNode = function (el, relativeRoot) {
  var exception, result;
  try {
    result = simpleXPathJQuery.call(el, relativeRoot);
  } catch (error) {
    exception = error;
    console.log("jQuery-based XPath construction failed! Falling back to manual.");
    result = simpleXPathPure.call(el, relativeRoot);
  }
  return result;
};

Util.nodeFromXPath = function (xp, root) {
  var i, idx, len, name, node, step, steps;
  steps = xp.substring(1).split("/");
  node = root;
  for (i = 0, len = steps.length; i < len; i++) {
    step = steps[i];
    [name, idx] = step.split("[");
    idx = idx != null ? parseInt((idx != null ? idx.split("]") : void 0)[0]) : 1;
    node = findChild(node, name.toLowerCase(), idx);
  }
  return node;
};

